#!/bin/bash

function printDivider() {
  local columns
  columns=$(tput cols)
  printf '─%.0s' $(seq 1 "$columns")
  echo ''
}

# Global state
user_name=""
greeting=""

function step1() {
  echo "Step 1: Ask for your name"
  read -rp "Enter your name: " user_name
}

function step2() {
  echo "Step 2: Customize greeting"
  if [[ -z "$user_name" ]]; then
    echo "Name not set. Go back to Step 1."
  else
    read -rp "Enter a greeting for $user_name: " greeting
  fi
}

function step3() {
  echo "Step 3: Display result"
  if [[ -n "$user_name" && -n "$greeting" ]]; then
    echo "$greeting, $user_name!"
  else
    echo "Incomplete information. Go back and complete previous steps."
  fi
}

steps=("step1" "step2" "step3")
current_step=0

function showMenu() {
  echo
  echo -e "[\e[1mn\e[0m] Next    [\e[1mp\e[0m] Previous    [\e[1mq\e[0m] Quit"
  echo -n "Choice: [N/p/q] "
  IFS= read -r -n1 choice
  echo
  [[ -z "$choice" ]] && choice="n"
}

function runSteps() {
  while true; do
    clear
    echo -e "Running \e[1m${steps[$current_step]}\e[0m (Step $((current_step + 1)) of ${#steps[@]})"
    printDivider
    "${steps[$current_step]}"
    printDivider
    showMenu
    case "$choice" in
      n|N)
        if (( current_step < ${#steps[@]} - 1 )); then
          ((current_step++))
        else
          echo "Already at the last step."; read -rp "Press enter to continue..."
        fi
        ;;
      p|P)
        if (( current_step > 0 )); then
          ((current_step--))
        else
          echo "Already at the first step."; read -rp "Press enter to continue..."
        fi
        ;;
      q|Q)
        echo "Exiting."
        break
        ;;
      *)
        echo "Invalid input."; read -rp "Press enter to continue..."
        ;;
    esac
  done
}

runSteps
